'use client';

import Header from '../../../components/Header';
import MobileHeader from '../../../components/MobileHeader';
import Footer from '../../../components/Footer';
import MediaCard from '../../../components/MediaCard';
import { useTranslations } from 'next-intl';
import { useState, useEffect } from 'react';

export default function MediaPage() {
  const t = useTranslations('MediaPage');
  const [isDesktop, setIsDesktop] = useState(false);
  
  // Debug logs
  console.log('MediaPage rendered, isDesktop:', isDesktop);
  console.log('Title translation:', t('title'));
  console.log('Article 1 title:', t('article1_title'));

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 768);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  const mediaArticles = [
    {
      id: 6,
      title: t('article6_title'),
      description: t('article6_desc'),
      date: "Feb 5, 2025",
      source: "www.hubbis.com",
      image: "/images/media/16de14df67ed9b041f8fce6c42bef0d6a459435e.png",
      link: "https://www.hubbis.com/article/predicting-the-market-for-2025"
    },
    {
      id: 5,
      title: t('article5_title'),
      description: t('article5_desc'),
      date: "Feb 6, 2025",
      source: "www.hubbis.com",
      image: "/images/media/9e9a33f5df3cb82fa5292bef5a63b7eb2011f3aa.png",
      link: "https://www.hubbis.com/article/where-will-2025-investments-be-made-by-family-offices"
    },
    {
      id: 4,
      title: t('article4_title'),
      description: t('article4_desc'),
      date: "Apr 13, 2025",
      source: "www.linkedin.com",
      image: "/images/media/2cbc1a1d442c2a01f854a66e52926951a6ddcd24.png",
      link: "https://www.linkedin.com/feed/update/urn:li:activity:7320641763021316096/"
    },
    {
      id: 3,
      title: t('article3_title'),
      description: t('article3_desc'),
      date: "Apr 6, 2025",
      source: "www.linkedin.com",
      image: "/images/media/07c00710b3cdaf28277b51aaf038ee63b59ba416.jpg",
      link: "https://www.linkedin.com/feed/update/urn:li:activity:7313098413418381313/"
    },
    {
      id: 2,
      title: t('article2_title'),
      description: t('article2_desc'),
      date: "Mar 15, 2025",
      source: "www.linkedin.com",
      image: "/images/media/890f03e681c970af9cbfefc0db4d38bddcf287c2.png",
      link: "https://www.linkedin.com/feed/update/urn:li:activity:7305953003130245120/"
    },
    {
      id: 1,
      title: t('article1_title'),
      description: t('article1_desc'),
      date: "Feb 15, 2025",
      source: "www.linkedin.com",
      image: "/images/media/e4007d48af4e1fec54c9ea24fb8c6986edd641f8.jpg",
      link: "https://www.linkedin.com/feed/update/urn:li:activity:7296226253001359360/"
    }
  ];

  return (
    <div className="min-h-screen bg-[#F5F1F0] font-roboto">
      {isDesktop ? <Header /> : <MobileHeader />}
      
      {/* Title Section */}
      <section className="flex h-[146px] px-8 md:px-8 justify-center items-center bg-[#F5F1F0]">
        <div className="flex-1 text-center">
          <h1 className="text-[#1C1C1C] text-[40px] font-light leading-[115%] tracking-[-1.2px]">
            {t('title')}
          </h1>
        </div>
      </section>

      {/* Media Articles Grid */}
      <section className="w-full max-w-[1440px] mx-auto px-3 md:px-8 pb-[50px] bg-[#F5F1F0]">
        <div className="flex flex-col gap-10">
          {isDesktop ? (
            <>
              {/* Desktop Layout - First Row */}
              <div className="flex gap-10">
                {mediaArticles.slice(0, 3).map((article) => (
                  <MediaCard
                    key={article.id}
                    title={article.title}
                    description={article.description}
                    date={article.date}
                    source={article.source}
                    image={article.image}
                    link={article.link}
                  />
                ))}
              </div>

              {/* Desktop Layout - Second Row */}
              <div className="flex gap-10">
                {mediaArticles.slice(3, 6).map((article) => (
                  <MediaCard
                    key={article.id}
                    title={article.title}
                    description={article.description}
                    date={article.date}
                    source={article.source}
                    image={article.image}
                    link={article.link}
                  />
                ))}
              </div>
            </>
          ) : (
            /* Mobile Layout - All cards in single column */
            <div className="flex flex-col gap-10">
              {mediaArticles.map((article) => (
                <MediaCard
                  key={article.id}
                  title={article.title}
                  description={article.description}
                  date={article.date}
                  source={article.source}
                  image={article.image}
                  link={article.link}
                />
              ))}
            </div>
          )}
        </div>
      </section>

      <Footer />
    </div>
  );
} 